<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Device extends Model
{
    protected $fillable = [
        'device_uid',
        'name',
        'ro_id',
        'dealer_id',
        'mac_address',
    ];

    public function latestData()
    {
        return $this->hasOne(DeviceLatestData::class);
    }

    public function dataLogs()
    {
        return $this->hasMany(DeviceDataLog::class);
    }
    public function ro()
    {
        return $this->belongsTo(RoMaster::class, 'ro_id');
    }

    public function dealer()
    {
        return $this->belongsTo(User::class, 'dealer_id');
    }    
}
