<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DeviceLatestData extends Model
{
    protected $table = 'device_latest_data';

    protected $fillable = [
        'device_id',
        'payload',
        'received_at',
        'timestamp',
        'ammonia',
        'sulphur',
        'voc',
    ];

    protected $casts = [
        'payload' => 'array',
        'received_at' => 'datetime',
    ];

    public function device()
    {
        return $this->belongsTo(Device::class);
    }
}
