<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sensor_readings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('device_id')->constrained('device_master');
            $table->timestamp('reading_time');
            $table->float('odour_raw');
            $table->float('odour_normalized');
            $table->enum('hygiene_status', ['green','amber','red']);
            $table->timestamps();

            $table->index(['device_id','reading_time']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sensor_readings');
    }
};
