<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('daily_photos', function (Blueprint $table) {
    $table->id();
    $table->foreignId('ro_id')->constrained('ro_master');
    $table->date('date');
    $table->enum('category', ['toilet','basin','floor','consumables']);
    $table->string('photo_path');
    $table->json('ai_result')->nullable();
    $table->timestamps();

    $table->unique(['ro_id','date','category']);
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('daily_photos');
    }
};
