@extends('layouts.app')
@section('content')
<h4 class="mb-3">Devices</h4>

<table class="table table-bordered bg-white">
    <thead class="table-light">
        <tr>
            <th>MAC Address</th>
            <th>Name</th>
            <th>RO Name</th>
            <th>Dealer Name</th>
            <th>Created At</th>
            <th>Updated At</th>
            <!-- <th>Ammonia</th>
            <th>Sulphur</th>
            <th>VOC</th>
            <th>Timestamp</th> -->
            <!-- <th>Last Data</th> -->
            <!-- <th>Received At</th> -->
            <!-- <th>Status</th> -->
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @forelse($devices as $device)
        <!-- <pre>{{print_r($device)}}</pre> -->
            <tr>
                <td>{{ $device->mac_address }}</td>
                <td>{{ $device->name ?? '-' }}</td>
                <!-- <td>{{ $device->latestData->ammonia ?? '-' }}</td>
                <td>{{ $device->latestData->sulphur ?? '-' }}</td>
                <td>{{ $device->latestData->voc ?? '-' }}</td> -->
                <!-- <td>{{ $device->latestData->timestamp ?? '-' }}</td> -->
                <td>
                            {{ $device->ro->name ?? '—' }}
                        </td>

                        <td>
                            {{ $device->dealer->name ?? '—' }}
                        </td>

                        <td>
                            {{ optional($device->created_at)?->format('d-m-Y H:i A') ?? 'No Data' }}
                        </td>

                        <td>
                            {{ optional($device->updated_at)?->format('d-m-Y H:i A') ?? 'No Data' }}
                        </td>


                <!-- <td>
                    @if($device->latestData)
                        <pre class="mb-0 small">{{ json_encode($device->latestData->payload, JSON_PRETTY_PRINT) }}</pre>
                    @else
                        <span class="text-muted">No data</span>
                    @endif
                </td>
                <td>
                    {{ $device->latestData?->received_at?->diffForHumans() ?? '-' }}
                </td> -->
                <!-- <td>
                    @if($device->latestData)
                        <span class="badge bg-success">ONLINE</span>
                    @else
                        <span class="badge bg-secondary">NO DATA</span>
                    @endif
                </td> -->
                <td>
                    <a href="{{route('device-data',$device->id)}}" class="btn btn-sm btn-primary">
                        View Data
                    </a>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="6" class="text-center text-muted">No devices found</td>
            </tr>
        @endforelse
    </tbody>
</table>
<div class="d-flex justify-content-center mt-3">
    {{ $devices->links('pagination::bootstrap-5') }}
</div>
@endsection
