<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DeviceController;
use Illuminate\Support\Facades\Route;

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/dashboard', function () {
    // return view('dashboard');
    return redirect()->route('device-list');

})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/devices', [DeviceController::class, 'index'])->name('device-list');
    Route::get('/devices/{device}', [DeviceController::class, 'show'])->name('device-data');
    Route::get('/devices/{device}/logs', [DeviceController::class, 'logs'])->name('device-log');


Route::get('/devices/{device}/logs/excel', [DeviceController::class, 'exportExcel'])
    ->name('device-logs-excel');

Route::get('/devices/{device}/logs/pdf', [DeviceController::class, 'exportPdf'])
    ->name('device-logs-pdf');
});


require __DIR__.'/auth.php';
