

<?php $__env->startSection('content'); ?>
<a href="<?php echo e(route('device-data',$device->id)); ?>" class="btn btn-sm btn-secondary mb-3">← Back</a>

<div class="d-flex justify-content-between align-items-center mb-2">
    <h4>Device Logs – <?php echo e($device->device_uid); ?></h4>

      <span class="badge bg-dark text-white px-3 py-2 fw-semibold">
    🔄 Auto refresh in <span id="countdown">20</span>s
</span>
</div>

<form method="GET" class="row g-2 mb-3 align-items-end">
    <div class="col-md-3">
        <label class="form-label">From Date</label>
        <input type="date" name="from_date" value="<?php echo e(request('from_date')); ?>" class="form-control">
    </div>

    <div class="col-md-3">
        <label class="form-label">To Date</label>
        <input type="date" name="to_date" value="<?php echo e(request('to_date')); ?>" class="form-control">
    </div>

    <div class="col-md-6 d-flex gap-2">
        <button type="submit" class="btn btn-primary btn-sm">
            🔍 Filter
        </button>

        <a href="<?php echo e(route('device-logs-pdf', request()->all() + ['device' => $device->id])); ?>"
           class="btn btn-danger btn-sm">
            📄 PDF
        </a>

        <a href="<?php echo e(route('device-logs-excel', request()->all() + ['device' => $device->id])); ?>"
           class="btn btn-success btn-sm">
            📊 Excel
        </a>

        <a href="<?php echo e(route('device-log', $device->id)); ?>"
           class="btn btn-secondary btn-sm">
            ❌ Reset
        </a>
    </div>
</form>



<table class="table table-bordered bg-white">
    <thead class="table-light">
        <tr>
            <th>Ammonia</th>
            <th>Sulphur</th>
            <th>VOC</th>
            <th>Timestamp</th>
            <th>Received At</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($log->ammonia ?? '-'); ?></td>
                <td><?php echo e($log->sulphur ?? '-'); ?></td>
                <td><?php echo e($log->voc ?? '-'); ?></td>
                <td><?php echo e($log?->timestamp ? date('d-m-Y h:i:s A', strtotime($log->timestamp)) : '-'); ?></td>
                <td><?php echo e($log?->updated_at ? date('d-m-Y h:i:s A', strtotime($log->updated_at)) : '-'); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="5" class="text-center text-muted">No logs found</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<div class="d-flex justify-content-center mt-3">
    <?php echo e($logs->links('pagination::bootstrap-5')); ?>

</div>


<script>
    let seconds = 20;
    const countdownEl = document.getElementById('countdown');

    const timer = setInterval(() => {
        seconds--;
        countdownEl.textContent = seconds;

        if (seconds <= 0) {
            clearInterval(timer);
            window.location.reload();
        }
    }, 1000);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\llm\washroom-hygiene\resources\views/devices/logs.blade.php ENDPATH**/ ?>