

<?php $__env->startSection('content'); ?>
<a href="<?php echo e(route('device-list')); ?>" class="btn btn-sm btn-secondary mb-3">← Back</a>



<div class="d-flex justify-content-between align-items-center mb-2">
    <h4>Device Details</h4>

    <span class="badge bg-dark text-white px-3 py-2 fw-semibold">
    🔄 Auto refresh in <span id="countdown">10</span>s
</span>
</div>





<table class="table table-bordered bg-white">
    <tr>
        <th>MAC Address</th>
        <td><?php echo e($device->mac_address); ?></td>
    </tr>
    <tr>
        <th>Name</th>
        <td><?php echo e($device->name ?? '-'); ?></td>
    </tr>
    <!-- <tr>
        <th>Latest Received</th>
        <td><?php echo e($device->latestData?->received_at ?? 'No data'); ?></td>
    </tr> -->


    <tr>
            <th>Ammonia</th>

            <td><?php echo e($device->latestData->ammonia ?? '-'); ?></td>
    </tr>
    <tr>
            <th>Sulphur</th>

            <td><?php echo e($device->latestData->sulphur ?? '-'); ?></td>
    </tr>
    <tr>
            <th>VOC</th>

            <td><?php echo e($device->latestData->voc ?? '-'); ?></td> 
    </tr>
    <tr>
            <th>Timestamp</th>

           <td><?php echo e($device->latestData?->timestamp ? date('d-m-Y h:i:s A', strtotime($device->latestData->timestamp)) : '-'); ?></td>

    </tr>
    <tr>
            <th>Received At</th>

           <td><?php echo e($device->latestData?->updated_at ? date('d-m-Y h:i:s A', strtotime($device->latestData->updated_at)) : '-'); ?></td>

    </tr>

</table>

<!-- <h5 class="mt-4">Latest Payload</h5>

<div class="bg-dark text-white p-3 rounded">
    <pre class="mb-0">
<?php echo e(json_encode($device->latestData?->payload, JSON_PRETTY_PRINT) ?? 'No data received yet'); ?>

    </pre>
</div> -->

<a href="<?php echo e(route('device-log',$device->id)); ?>" class="btn btn-primary mt-3">
    View History Logs
</a>

<script>
    let seconds = 10;
    const countdownEl = document.getElementById('countdown');

    const timer = setInterval(() => {
        seconds--;
        countdownEl.textContent = seconds;

        if (seconds <= 0) {
            clearInterval(timer);
            window.location.reload();
        }
    }, 1000);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\llm\washroom-hygiene\resources\views/devices/show.blade.php ENDPATH**/ ?>